/*++++ FILE DESCRIPTION ++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/**
PROJECT:                AMMOS GX40x

@file                   $Workfile: rs_gx40x_global_frame_header_if_defs.h $
@copyright              (c) 2002 Rohde & Schwarz, Munich
@version                $Revision: 3 $

@author                 $Author: Hisch_m $

@responsible            Schreiber

@language               ANSI-C

COMPILER:               ANSI C conform

@description            Types and constant definitions for data stream frames
                        Prefix 'FRH' == 'FRame Header'

@see                    

@pattern

------ End of file description ---------------------------------------------*/

#ifndef _RS_GX40X_GLOBAL_FRAME_HEADER_IF_DEFS_H
#define _RS_GX40X_GLOBAL_FRAME_HEADER_IF_DEFS_H

/*++++ INCLUDE FILES +++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include "rs_gx40x_p_types.h"

/*---- End of include files ------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/*++++ DEFINES +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/** Magic word - used for synchronising data stream frames. */
#define kFRH_MAGIC_WORD               0xFB746572UL

/** The maximum length, in units of 32bit words, of a data stream frame.
    This length includes the length of the frame the header! */
#define kFRH_FRAME_LENGTH_MAX         0x100000UL

/*---- End of defines ------------------------------------------------------*/


/*++++ TYPES DECLARATION +++++++++++++++++++++++++++++++++++++++++++++++++++*/

/** Structure type for a generic data stream frame header */
typedef struct
{
  /** A magic word; used for synchronisation. */
  ptypUINT uintMagicWord;

  /** The total length, in units of 32bit words, of the data stream frame.
      This includes the length of the header.
      Magic Words occur after (this number - 1) of 32bit words. */
  ptypUINT uintFrameLength;  /** This may not exceed 'kFRH_FRAME_LENGTH_MAX' */
  
  /** The (running) number of the current frame. */
  ptypUINT uintFrameCount;

  /** The type of data carried in this frame.
      The possible list of possible data stream frame types is in: rs_gx40x_global_frame_types_if_defs.h */
  ptypUINT uintFrameType;

  /** The length, in 32bit units, of the data header following this frame header.
      This value does not vary within any continuous data stream. */
  ptypUINT uintDataHeaderLength;

  /** Reserved field */
  ptypUINT uintReserved;

} typFRH_FRAMEHEADER;

/*---- End of types declaration --------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif /* ifndef for file (multi)inclusion lock */
/***** End of File **********************************************************/
